/*********************************************************************************
版权所有     :   Tencent
模块名       :   WmpfHostInterface
文件实现功能 :   Wmpf接口头文件
作者         :   elviskqiu
版本         :   1.0
备注         :
--------------------------------------------------------------------------------
修改记录 :
日 期        版本     修改人			修改内容
2021/11/14  1.0    elviskqiu         创建
*********************************************************************************/
#ifndef INTERFACE_WMPF_HOST_INTERFACE_H_
#define INTERFACE_WMPF_HOST_INTERFACE_H_

#include "wmpf_interface_common_def.h"
#ifdef OS_WIN
#include <objbase.h>
#else
#define interface struct
#endif

#ifdef __OBJC__
@class NSWindow;
@class NSView;
#else
class NSWindow;
class NSView;
#endif

interface ICoreServiceHandler;
interface IWebViewEventHandler;
interface IBrowsingService;
interface IWebViewManager;
interface IAppletManager;

// 获取 BrowsingService 实例（单例）
// 使用 GetBrowsingService()->QueryInterface 接口查询获取其他接口。
WMPF_EXPORT IBrowsingService* GetBrowsingService();
WMPF_EXPORT int GetAppletPublicLibVersion();
WMPF_EXPORT bool IsFeatureSupport(char* name, size_t name_size);
WMPF_EXPORT PathType GetRealPath(const char* link_path,
                                 size_t link_size,
                                 char* real_path,
                                 size_t* real_size);
// 此接口提供给企微使用，微信若需使用可通过IsFeatureSupport规避，否则会有老包兼容问题
WMPF_EXPORT int GetXwebVersion();

// 务必注意，以下已有的接口不可修改导出函数
interface IBrowsingService : public WIUnknown {
  [[deprecated]] virtual void SetIfShareWmpfCore(bool share_wmpf_core) = 0;
  [[deprecated]] virtual bool ShareWmpfCore() = 0;

  // 初始化 WMPF, 拉起 browser 进程。
  //
  // - |config| 为包含配置信息的 json 字符串
  //   参数 (仅部分，更多参数列表见 applet_switches.h ):
  //   - "product-id": 产品 ID。必须正确填写否则可能不正确工作。见 |ProductId|
  //   - "log-level":  日志级别。DEBUG 版不生效，始终打印所有日志。见
  //     |TLogLevel|
  //                   默认值为 kLevelAll(0), 普通信息使用 kLevelInfo(2)
  //   - "no-preload": 是否禁用小程序预加载。默认不禁用
  //   - "max-retry-count": browser 进程挂了重新拉起的重试次数，默认值为 5
  //   - "wmpf_root_dir": 指定数据目录根目录。** 必须是绝对路径 **。
  //   - "enable-applet-v3": 启用 AppletManagerV3 接口并禁用 AppletManager 接口
  //                         AppletManager 是 3.x 老现网微信使用的接口。4.x
  //                         微信以及其他业务（SDK 等）须使用 V3 接口。默认为
  //                         false
  //   - "ilink-debug-net": 启用 IlinkStartConfig 中的 set_debug_net
  //                        启用后会让 ilink 走 995 测试环境
  //
  //   - "product-dir"   xweb根目录。企业微信用，在 XWeChat 和 SDK 下不生效。
  //     %APPDATA% + Tencent + [WeChat|WXWork|<product-dir>] + log + radium
  //  -"xweb-custom-command" 自定义启动参数,仅debug 版可用
  // - |runtime_path| 为 WMPF 目录根路径，不包含 "runtime" 目录。
  //   e.g. Windows 下会尝试启动 <runtime_path>\runtime\WeChatAppEx.exe
  //   NOTE: 拉起可执行文件前，会解析路径中的符号链接
  //
  // - |s_handler| 为传入的回调处理指针
  virtual int InitilizeBrowsingCore(const char* config,
                                    const char* runtime_path,
                                    ICoreServiceHandler* s_handler) = 0;

  [[deprecated("Use InitilizeBrowsingCore instead")]] virtual int
  InitilizeAppletCore(const char* config, const char* runtime_path,
                      ICoreServiceHandler* s_handler) = 0;

  [[deprecated("Use UninitializeBrowsingCore instead")]] virtual void
  UninitializeAppletCore() = 0;

  // 这个接口现在什么都不会干
  virtual void UninitializeBrowsingCore() = 0;

  // 返回值 false 表示未找到对应指令
  virtual bool CallCommonCommand(const char* command_name, int32_t callback_id,
                                 const char* data,
                                 const unsigned int data_size) = 0;

  [[deprecated]] virtual void SetUseAppletManagerV2(bool use_version_2) = 0;
};

interface IWebViewManager : public WIUnknown {
  virtual void CreateWebView(HWND parent_window, const char* startup_url,
                             const char* content,
                             const unsigned int content_size, RECT* rect,
                             IWebViewEventHandler* handler) = 0;
  virtual void LoadData(int32_t webview_id, const char* url,
                        const char* content,
                        const unsigned int content_size) = 0;
  virtual void Navigate(int32_t webview_id, const char* url) = 0;

  virtual void NavigateWithHeaders(int32_t webview_id, const char* url,
                                   const char* extra_headers) = 0;
  virtual void GoBack(int32_t webview_id) = 0;
  virtual void GoForward(int32_t webview_id) = 0;
  virtual void Reload(int32_t webview_id) = 0;
  virtual void Stop(int32_t webview_id) = 0;
  virtual void ExecuteJavaScript(int32_t webview_id, const char* js_str) = 0;
  virtual void SetEnableSaveImg(int32_t webview_id, bool enable_save_img) = 0;
  virtual void CloseBrowser(int32_t webview_id) = 0;

  virtual void Invoke(int32_t webview_id, const char* method,
                      const char* params[],
                      const unsigned int params_count) = 0;
  virtual void ClearNavigationEntry(int32_t webview_id) = 0;
  virtual void SetFocus(int32_t webview_id, bool bFocus) = 0;

  virtual bool CallCommonCommand(const char* command_name, int32_t webview_id,
                                 int32_t callback_id, const char* data,
                                 const unsigned int data_size) = 0;
};

interface IWebViewManager2 : public IWebViewManager {
  virtual void CreateWebView2(HWND parent_window, const char* startup_url,
                              RECT* rect, const char* config,
                              const unsigned int config_size,
                              IWebViewEventHandler* handler) = 0;
};

class CallBackBuffer {
 public:
  virtual ~CallBackBuffer() {}
  virtual void SetString(const char* data, uint32_t length) = 0;
  virtual const char* Data() const = 0;
  virtual int Length() const = 0;
};

// 用于全局回调接口GetWechatResInfo传递数据用
struct WMPFResInfo {
  const char* url;
  bool is_main_frame;
};

// 需对齐MMCefCallBackBase
interface IWebViewEventHandler : public WIUnknown {
  virtual void OnWebViewCreated(int32_t web_view_id, HWND hwnd) = 0;
  virtual void OnWebViewClosed() = 0;
  virtual bool OnLoadStart(bool is_main_frame, const char* url) = 0;
  virtual void OnLoadEnd(bool is_main_frame, const char* url) = 0;
  virtual void OnLoadError(bool is_main_frame, const char* url,
                           int error_code) = 0;
  virtual void OnShouldInterceptRequest(WMPFResInfo * info,
                                        CallBackBuffer & mimeType,
                                        CallBackBuffer & buffer) = 0;
  // form MMCefCallbackBase
  virtual void OnTitleChange(const char* url, const char* title) = 0;
  virtual void OnAddressChanged(bool is_main_frame, const char* url) = 0;
  virtual void OnNavigateStateChange(bool canBack, bool canForward) = 0;
  virtual void OnSetFullScreen(bool fullscreen) = 0;
  virtual bool OnBeforePopup(bool is_main_frame, const char* url) = 0;
  // from XWebListener xweb_sdk.h
  virtual bool OnShouldOverrideUrlLoading(bool is_main_frame,
                                          const char* str_url) = 0;
  // Note: 为了对齐微信客户端接口。保证新旧版本兼容性问题。
  // 这个函数虽然不再使用，但是不能删除
  virtual bool OnGetProtocolExecutionAllow(const char* url) = 0;
  virtual void OnBeforeContextMenu(int32_t max_count_to_hide,
                                   int32_t hide_cmd_list[],
                                   int32_t& hide_cmd_list_size) = 0;
  virtual void OnContextMenuCommand(int cmd_id, const char* url) = 0;
  virtual bool OnCefKeyEvent(bool inEditableField, int32_t keyCode) = 0;
  virtual void OnRenderProcessGone(int32_t status_code) = 0;
  virtual void MMV8CallNative(int instance_id, const char* str,
                              CallBackBuffer& buffer) = 0;
  virtual bool OnCanAcessFile(const char* path) = 0;

  virtual bool OnCommonEventHappened(const char* event_name,
                                     int32_t callback_id, const char* data,
                                     const unsigned int data_size) = 0;
};

// IBrowsingService 回调处理接口。
interface ICoreServiceHandler : public WIUnknown {
  virtual void OnContextInitialized() = 0;
  virtual void OnServiceDisconnected() = 0;

  virtual bool OnCommonEventHappened(const char* event_name,
                                     int32_t callback_id, const char* data,
                                     const unsigned int data_size) = 0;
};

using JsApiHanlderCallback = bool (*)(const char* app_id,
                                      const char* api_name,
                                      const char* data,
                                      const unsigned int size,
                                      int task_id);

using EventHandlerCallback = bool (*)(const char* event_name,
                                      int event_id,
                                      const char* data,
                                      const unsigned int size);

interface IAppletManager : public WIUnknown {
  virtual bool LaunchApplet(const char* app_id, const char* init_config,
                            const unsigned int config_size) = 0;
  virtual void SetJsApiHandlerCallback(JsApiHanlderCallback handler) = 0;
  virtual void SendJsApiHandlerResponse(int task_id, const char* data,
                                        const unsigned int size) = 0;
  virtual bool EncryptBufToFile(const char* key, const char* filePath,
                                const char* pData, int size) = 0;
  virtual void CallCommonApi(const char* api, const char* app_id,
                             const char* data, const unsigned int data_size);
  virtual void SetEventHandlerCallback(EventHandlerCallback handler) = 0;

  virtual bool CallCommonCommand(const char* command_name, int32_t callback_id,
                                 const char* app_id, const char* data,
                                 const unsigned int data_size);
};

interface [[deprecated]] IAppletManagerV2 : public WIUnknown {
  // 小程序交互
  virtual void LaunchApplet(
      const char* app_id, size_t app_id_length, const char* launch_cfg_json,
      size_t launch_cfg_json_length,
      void (*callback)(const char* app_id, int result_code,
                       const char* error_desc)) = 0;
  virtual void CloseApplet(const char* app_id, size_t app_id_length) = 0;
  virtual void SetJsApiHandler(
      void (*handler)(const char* app_id, const char* api_name,
                      const char* data, size_t size, int task_id)) = 0;
  virtual void SetAppletEventHandler(void (*handler)(
      const char* event_name, const char* data, size_t size, int task_id)) = 0;
  virtual void SendJsApiOrEventResponse(int task_id, const char* data,
                                        size_t data_size) = 0;

  // 基础库等数据落地加密保存
  virtual bool WriteFileWithEncryption(
      const char* data_buffer, size_t buffer_len, const char* save_path,
      size_t path_len, const char* key, size_t key_len) = 0;
};

// 区别于 V2, 该接口使用 runtime 内置包管理启动小程序
// 用于启动关闭小程序，向小程序发送事件，以及处理小程序运行期间发生的事件
// 涉及的 protobuf 字段都位于 wmpf_host_interface\include\wmpf_host.proto
interface IAppletManagerV3 : public WIUnknown {
  // 打开小程序回调。result_code 详见 enum class LaunchAppletResult，为保持 ABI
  // 保持类型为 int
  using LaunchCallback =
      void(const char* app_id, int result_code, const char* error_desc);

  // 启动小程序
  // |app_id|: 要启动的小程序。目前仅仅用于传递给回调函数，建议和 pb
  // 里的保持一致。 |launch_config_pb|: 启动参数 protobuf，见 message
  // LaunchConfig |launch_config_pb_length|: |launch_config_pb| 的长度，单位字节
  // |callback|: 结果回调。result_code 是 0 则代表成功
  virtual void LaunchApplet(const char* app_id, const char* launch_config_pb,
                            size_t launch_config_pb_length,
                            LaunchCallback* callback) = 0;

  // 关闭小程序
  // |app_id|: 要关闭的小程序，留空以关闭所有小程序。
  virtual void CloseApplet(const char* app_id) = 0;

  // JsApiHanlder: 响应小程序运行期间的前端事件
  // 如果处理了这个事件返回 true，否则返回 false。
  // 对于处理了的事件需要在处理结束后使用传入的 task_id 调用
  // |SendJsApiOrEventResponse| 进行回调。具体回调数据格式取决于事件本身。
  using JsApiHanlder = bool(const char* app_id, const char* api_name,
                            const char* data, size_t data_size, int task_id);
  virtual void SetJsApiHandler(JsApiHanlder * jsapi_handler) = 0;

  // EventHandler: 响应小程序运行期间的内核事件
  // 如果处理了这个事件返回 true，否则返回 false。
  // 对于处理了的事件需要在处理结束后使用传入的 task_id 调用
  // |SendJsApiOrEventResponse| 进行回调。具体回调数据格式取决于事件本身。
  using EventHandler = bool(const char* event_name, const char* data,
                            size_t data_size, int task_id);
  virtual void SetAppletEventHandler(EventHandler * event_handler) = 0;

  virtual void SendJsApiOrEventResponse(int task_id, const char* data,
                                        size_t data_size) = 0;
  virtual void CallAppletCommand(const char* command_name, int32_t task_id,
                                 const char* app_id, const char* data,
                                 size_t data_size) = 0;
};

// ilink 登录认证接口。供 SDK 等业务使用。
// 微信自带登录态/企微不需要登录态，请勿使用此接口
interface IILinkAuthManager : public WIUnknown {
  // 用户信息回调
  // |login_status|: 用户当前登录状态。见 |IlinkLoginStatus|
  // |login_type|: 登录类型，见 |IlinkLoginType|
  // |login_scene|: 登录场景，见 |IlinkLoginScene|
  // |callback_data|: 调用时附带的额外参数
  using GetUserInfoCallback =
      void(int32_t login_status, uint32_t login_type, uint64_t uin,
           int32_t login_scene, void* callback_data);

  // 获取当前用户信息。未登录的情况下也可以查询，如果先前登录过并可以自动登录会返回
  // 相关信息。结果通过 callback 异步返回
  virtual void GetUserInfo(GetUserInfoCallback * callback,
                           void* callback_data) = 0;

  // 登录接口回调
  // |login_type|: 登录类型，见 |IlinkLoginType|
  // |error|: 错误码。负数是后台 CGI 返回的错误码，正数代表是 ilink 或是 WMPF
  //          产生的错误，详见 |AuthManagerErrCode|
  // |resp_pb|: 登录返回的 protobuf 结果
  // |resp_len|: resp_pb 的长度
  // |callback_data|: 调用时附带的额外参数
  using LoginCallback =
      void(int32_t login_type, int32_t error, const char* resp_pb, int resp_len,
           void* callback_data);

  // 认证登录。|ilink_buffer| 是用于登录的 auth buffer 凭证。传入拿到的 base64
  // 即可 结果通过 callback 异步返回
  virtual void ThirdAppLogin(const char* ilink_buffer, LoginCallback* callback,
                             void* callback_data) = 0;
  // 自动登录。|business_req_buffer|
  // 是曾经给腾讯会议预留的一个额外票据。留空即可 结果通过 callback 异步返回
  virtual void AutoLogin(const char* business_req_buffer,
                         LoginCallback* callback, void* callback_data) = 0;

  // 登出接口回调
  // |error|: 错误码。负数是后台 CGI 返回的错误码，正数代表是 ilink 或是 WMPF
  //          产生的错误，详见 |AuthManagerErrCode|
  // |callback_data|: 调用时附带的额外参数
  using LogoutCallback = void(int32_t error, void* callback_data);

  // 登出当前登录的用户。会一并退出所有小程序等
  // 结果通过 callback 异步返回
  virtual void Logout(LogoutCallback callback, void* callback_data) = 0;

  using SessionTimeoutCallback = void();
  // 设置当前会话超时收到的回调
  // NOTE: 会话超时会自动关闭所有相关业务。此时可以通过 GetUserInfo 检查是否可以
  //       自动登录。如果无法自动登录则需重新认证登录
  virtual void SetSessionTimeoutCallback(SessionTimeoutCallback callback) = 0;
};

using BrowserCommandHandler = bool (*)(uint32_t callback_id,
                                       const char* command_name,
                                       const char* data,
                                       const unsigned int size);

interface IWeChatBrowserManager : public WIUnknown {
  virtual void AddTab(int type, const char* url, const unsigned int url_size,
                      const char* init_config,
                      const unsigned int config_size) = 0;

  virtual void CallBrowserCommand(const char* command_name,
                                  uint32_t callback_id, const char* data,
                                  const unsigned int data_size) = 0;
  // 如果 BrowserCommandHandler 接收到的 callback_id > 0, 必须有
  // SendBrowserCommandResponse 的调用，否则dll中会存在内存泄漏
  virtual void SendBrowserCommandResponse(
      uint32_t callback_id, const char* data, const unsigned int size) = 0;

  virtual void SetBrowserCommandHandler(BrowserCommandHandler) = 0;
};

#if defined(MACOS) || defined(OS_MAC)
interface IAppShimManager : public WIUnknown {
  virtual void Initialize() = 0;
  virtual NSWindow* GetNSWindowFromNativeWidgetId(uint64_t widget_id) = 0;
  virtual NSView* GetContentViewFromNativeWidgetId(uint64_t widget_id) = 0;

  enum class SynchronizeTiming {
    kBeforeTransactions,
    kAfterTransactions,
  };

  virtual void SynchronizeAnimationTransactions(SynchronizeTiming timing) = 0;
  virtual void ReclaimContentView(uint64_t widget_id) = 0;
};
#endif

/**********  Cookie begin *****************/
typedef struct wmpf_cookie_t {
  const char* name;
  const char* value;
  const char* domain;
  const char* path;
  int secure;
  int httponly;
  int64_t creation;
  int64_t last_access;
  int has_expires;
  int64_t expires;
  cookie_same_site_t same_site;
  cookie_priority_t priority;
} wmpf_cookie_t;

typedef void (*SetCookieHandler)(bool b_success,
                                 const char* cookie_name,                                 
                                 const char* error_str,
                                 void* userdata);

typedef void (*DeleteCookieHandler)(const char* url,
                                    const char* cookie_name,                                    
                                    int32_t num_deleted,
                                    void* userdata);

typedef void (*OnGetCookiesHandler)(wmpf_cookie_t cookies_array[],
                                    int total,
                                    void* userdata);

typedef void (*SetCookieListHandler)(const char* err_str,
                                     int  cookie_total,
                                     int  result_list[],
                                     const char* cookie_name[],
                                     const char* cookie_error_str[],                                    
                                     void* userdata);


interface ICookieManager : public WIUnknown {
  virtual void SetCookie(const char* url, wmpf_cookie_t* cookie,SetCookieHandler callback ,void* userdata) = 0;  // callback default 0

  virtual void DeleteCookies(const char* url, const char* cookie_name, DeleteCookieHandler callback,void * userdata) = 0;  // callback default 0

  virtual void GetAllCookies(OnGetCookiesHandler callback, void* userdata) = 0;

  virtual void FlushCookieStore() = 0;

  virtual int64_t GetCurrentTimeMs() = 0;  // get Milliseconds  FSince  utc 1970 11
  
  virtual void SetCookieList(const char* url, wmpf_cookie_t* cookie_list[],
                             int cookie_num, SetCookieListHandler callback,
                             void* userdata) = 0;
};

/******************** DownloadManager********************/

struct DownloadItemInfo {
  int32_t id;
  const char* url;
  const char* mime_type;
  const char* suggested_name;
  const char* FullPath;
  bool IsComplete;
  int64_t ReceivedBytes;
  int64_t TotalBytes;
  int64_t PercentComplete;
  int64_t speed;
};

interface IDownloadHandler {
  //  OnBeforeDownload return 1 skip download  ,   return 0 normal download
  virtual int32_t OnBeforeDownload(int32_t webview_id,
                                   DownloadItemInfo download_item) = 0;

  virtual void OnDownloadUpdated(int32_t webview_id,
                                 DownloadItemInfo download_item) = 0;
};

/************** ResourceManager *****************/
interface IResourceManager : public WIUnknown {
  virtual int32_t MakeAsyncRes(WMPFResInfo * res) = 0;
  virtual int32_t CompleteAsyncRes(int32_t res_id) = 0;

  virtual int32_t WriteRespone(int32_t res_id, const char* mime_type,
                               const char* str_content) = 0;

  virtual int32_t WriteRespone(int32_t res_id, int32_t status_code,
                               const char* mime_type, const char* content,
                               int32_t content_len, const char** HeaderMap,
                               int HeaderMap_num, int res_type = 0) = 0;

  virtual int32_t WriteRespone(WMPFResInfo * res, int32_t status_code,
                               const char* mime_type, const char* content,
                               int32_t content_len, const char** HeaderMap,
                               int HeaderMap_num) = 0;

  virtual int32_t WriteRespone(int32_t res_id, const char* json_str) = 0;

  virtual int32_t AddInterceptRule(int32_t webview_id,
                                   const char* str_intercept_url) = 0;

  virtual int32_t WriteCustomUserAgent(WMPFResInfo * res, const char* ua) = 0;
  virtual int32_t WriteCustomUserAgentById(int32_t res_id, const char* ua) = 0;

  // get request  info
  virtual const char* GetMethod(WMPFResInfo * res) = 0;
  virtual const char* GetReferrerUrl(WMPFResInfo * res) = 0;

  virtual int32_t GetHeadMapNum(WMPFResInfo * res) = 0;
  virtual HeaderMapItem GetHeadMapItem(WMPFResInfo * res, int index) = 0;

  virtual int32_t GetPostDataNum(WMPFResInfo * res) = 0;
  virtual PostDataItem GetPostDataItem(WMPFResInfo * res, int index) = 0;

  virtual void dump() = 0;
};

/******** IDragHandler*****************/
interface IDragHandler {
  virtual bool CanDragEnter(int32_t webview_id, const char* file_name_list[],
                            int32_t file_num, int32_t mask) = 0;
};

/******** IPermissionHandler *****************/
// https://bitbucket.org/chromiumembedded/cef/src/6478/include/cef_permission_handler.h
interface IPermissionHandler {
  virtual int32_t OnShowPermissionPrompt(int32_t webview_id, int32_t prompt_id,
                                         const char* requesting_origin_url,
                                         uint32_t requested_type) = 0;
};

/******** IKeyboardHandler *****************/
// https://bitbucket.org/chromiumembedded/cef/src/6478/include/cef_keyboard_handler.h
interface IKeyboardHandler {
  virtual int32_t OnPreKeyEvent(int32_t webview_id,
                                const KeyEventInfo* event) = 0;
  virtual int32_t OnKeyEvent(int32_t webview_id, const KeyEventInfo* event) = 0;

  virtual uint32_t GetOnPreKeyEventFilter() = 0;  // return 0 for no filter ,
                                                  // filter by KeyEventFlag
};

/******** IPrintManager  *****************/
typedef void (*OnXWebPrintToPDFFinished)(
    int32_t webview_id,
    const char* path,
    int32_t ret);  // ret == 0 success , < 0  error num

interface IPrintManager : public WIUnknown {
  virtual void Print() = 0;

  virtual int PrintToPDF(int32_t webview_id, const char* path,
                         XWebPdfPrintSettings*,
                         OnXWebPrintToPDFFinished callback) = 0;
};

#ifndef OS_WIN
#undef interface
#endif
#endif  // INTERFACE_WMPF_HOST_INTERFACE_H_
