/*********************************************************************************
版权所有     :   Tencent
模块名       :   WmpfCommonDef
文件实现功能 :   Wmpf公共定义
作者         :   elviskqiu
版本         :   1.0
备注         :
--------------------------------------------------------------------------------
修改记录 :
日 期        版本     修改人			修改内容
2021/11/14  1.0    elviskqiu         创建
*********************************************************************************/

#ifndef WMPF_INTERFACE_COMMON_DEF_H_
#define WMPF_INTERFACE_COMMON_DEF_H_

#ifdef _WIN32
#include <Windows.h>
#endif

#include <atomic>

#ifndef interface
#define interface struct
#endif

enum class TabType {
  UNKNOWN = -1,   // 未知
  LINK = 0,       // 外链
  MP = 1,         // 公众账号
  SEARCH = 2,     // 搜一搜
  TOPSTORY = 3,   // 看一看
  LIVE = 4,       // 直播
  FINDER = 5,     // 视频号
  MUSIC = 6,      // 听一听
  LITEAPP = 7,    // liteapp
  WGLITEAPP = 8,  // wgliteapp
};

enum class PathType { UNKNOWN, LOCAL, NETWORK };

enum class IndependentWindowIcon {
  kIconDefault = 0,
  kIconXFilePdf,
  kIconXFileXls,
  kIconXFilePpt,
  kIconXFileDoc,
  kIconXEditorDefault,
  kIconXEditorNote
};

enum JsApiFromScene { FromSingleTab, FromMultiTab };

#define kIndependentWindowSubscriptionProfile "subscription_profile"
#define kIndependentWindowXFile "xfile"
#define kIndependentWindowXEditor "xeditor"
#define kIndependentWindowGroupInvitation "group_invitation"
#define kIndependentWindowH5Verification "h5_verification"
#define kIndependentWindowGeneralFloatWindow "general_float_window"
#define kIndependentWindowSimple "simple_window"
#define kWebviewWrapperWxGame "wxgame"
#define kInvalidGamePid 0xffffffff
#define kIndependentWindowPrint "print_window"

// kSharing为mac上“共享”功能
enum class IndependentWindowBtn {
  kNonExtraBtn = 0,
  kShareBtn = 1,
  kFavorite = 2,
  kSaveAs = 4,
  kOpenWith = 8,
  kAddToHandoff = 16,
  kFind = 32,
  kPrint = 64,
  kOpenWithDefault = 1 << 7,
  kCopyFile = 1 << 8,
  kOpenInFolder = 1 << 9,
  kSharing = 1 << 10,
  kOpenWithOnTitleBar = 1 << 11,
  kPinBtn = 1 << 12,
};

// 关闭、最大化、最小化按钮
enum class IndependentWindowCaptionBtn {
  kNonCaptionBtn = 0,
  kClose = 1,
  kMaximum = kClose << 1,
  kMinimum = kMaximum << 1,
  kRestore = kMinimum << 1
};

// 星标事件操作
enum class StarOperation {
  kUnknown = 0,
  kRequsetInfo = 1,
  kClick = 2,
  kFavorite = 3,
  kRemove = 4
};

// 焦点事件来源
enum class FocusSource { kNone = 0, kSYSTEM = 1, kNAVIGATION = 2 };

// #define interface struct
// #define UINT unsigned int
// #define ULONG unsigned long
typedef int INT;
typedef unsigned int UINT;
typedef unsigned long ULONG;
#if !defined(_WIN32)
typedef void* HWND;
typedef struct tagRECT {
  long left;
  long top;
  long right;
  long bottom;
} RECT, *PRECT, *NPRECT, *LPRECT;
#endif

#define IN
#define OUT

#ifdef BUILDING_WMPF_SHARED
#if defined(WIN32)
#define WMPF_EXPORT extern "C" __declspec(dllexport)
#else
#define WMPF_EXPORT extern "C" __attribute__((visibility("default")))
#endif  // WIN32
#elif USING_WMPF_SHARED
#define WMPF_EXPORT __declspec(dllimport)
#else
#if defined(MACOS) || defined(OS_MAC)
#define WMPF_EXPORT extern "C"
#else
#define WMPF_EXPORT
#endif  // OS_MAC
#endif  // BUILDING_WMPF_SHARED && USING_WMPF_SHARED

#define WMPF_ERRCODE_SUCCESS 0
#define WMPF_ERRCODE_FAIL -1

interface
#ifdef __clang__
    [[clang::lto_visibility_public]]
#endif
    WIUnknown {
  inline virtual INT QueryInterface(IN const char* type, OUT void** ppvObject);
  inline virtual ULONG AddRef(void);
  inline virtual ULONG Release(void);
};

INT WIUnknown::QueryInterface(IN const char* type, OUT void** ppvObject) {
  return WMPF_ERRCODE_FAIL;
}

ULONG WIUnknown::AddRef(void) {
  return 0;
}

ULONG WIUnknown::Release(void) {
  return 0;
}

// from Ilink
enum class IlinkLoginStatus : int {
  kIlinkLoginUnknown = -1,
  kIlinkLoginSuccess = 0,  // 已经成功登录
  kIlinkRequireManualLogin =
      1,  // 未登录，需要重新走FaceLogin/QrCodeLogin登录流程
  kIlinkRequireAutoLogin =
      2,  // 未登录，但本地有autoauth_key，需要走AutoLogin流程进行自动登录
};

// from Ilink
enum class IlinkLoginType : int {
  kIlinkLoginTypeNone = 0,
  kIlinkLoginTypeAuto = 1,
  kIlinkLoginTypeFace = 2,
  kIlinkLoginTypeQrCode = 3,
  kIlinkLoginTypeOAuth = 4,
  kIlinkLoginTypeThirdApp = 5,
  kIlinkLoginTypeVisitor = 6,
  kIlinkLoginTypeIEGGOAuth = 7
};

// from ilink
// 枚举值对齐 ilink_network_api.pb/IlinkAppSessionType
enum class IlinkLoginScene {
  kIlinkLoginSceneNone = 0,
  kIlinkLoginSceneFace = 1,
  kIlinkLoginSceneQrCode = 2,
  kIlinkLoginSceneThirdApp = 5,
  kIlinkLoginSceneOAuth = 6,
  kIlinkLoginSceneVisitor = 7
};

enum class LaunchAppletResult : int32_t {
  kOk = 0,
  kBackgroundUpdate = 1,

  kAppletMgrV3NotInitialized = 100,
  kNotLoggedIn = 101,
  kTranslateLinkInvalid = 102,
  kILinkInvalidProto = 103,
  kILinkNotInitialized = 104,
  kIlinkGetAppItemInfoFailed = 105,
  kILinkTranslateLinkCgiRespInvalid = 106,
  kClosed = 107,
  kAbortedByNewLaunch = 108,
  kAbortedShuttingdown = 109,

  kHostUnexpectedMojoBroken = 200,
  kIlinkUnexpectedCallbackDropped = 201,

  kForbiddenWxaAppServiceType = 300,
  kForbiddenWithOpenUrl = 301,
  kForbiddenWithAlertMsg = 302,
  kForbiddenWithNotExist = 303,
  kForbiddenWithNoPermission = 304,
};

enum class AuthManagerErrCode : int32_t {
  // note: 这是 ilink 返回的错误码和 WMPF 返回的错误码的集合
  // 负数的错误码为 CGI 返回的错误码，不在此列。
  // kIlinkTask 开头的错误码应和 |IlinkTaskErrCode| 保持严格一致

  // ********************** Ilink 产生的错误 **********************
  kIlinkTaskNoErr = 0,  // 网络组件透传没出现错误，可以进一步检查业务层数据包
  kIlinkTaskRespDataHandleErr =
      1,                     // CGI回包数据处理出错，主要在ECDH回包的计算时出现
  kIlinkTaskReqPackErr = 2,  // CGI本地打包失败

  kIlinkTaskAeproxyReturnErr =
      11,  // AEProxy报头的ret字段出现非枚举范围的错误码，可能是新增的，需要找后台一起确认
  kIlinkTaskAeproxyNotDataErr =
      12,  // AEProxy接入服务器回包没有带数据，一般是业务后台问题没有回包
  kIlinkTaskSessionTimeout = 13,  // 登录状态过期，等待重新登录上线
  kIlinkTaskAeproxySysErr = 14,  // AEProxy报头的ret字段为-1，找后台一起定位问题
  kIlinkTaskAeproxyArgErr = 15,  // AEProxy报头的ret字段为-2，找后台一起定位问题

  kIlinkTaskAppReturnErr = 21,       // appid层ret返回字段非枚举范围
  kIlinkTaskAppSessionTimeout = 22,  // appid层会话过期
  kIlinkTaskAppEcdhError = 23,       // appid层ecdh解密失败
  kIlinkTaskAppUnpackError = 24,     // app层解包失败
  kIlinkTaskAppNoDataError = 25,     // app层回包缺少数据，拉后台一起定位问题
  kIlinkTaskAppTooManyIdcRedirect = 26,  // app层auth IDC跳转次数过多
  kIlinkTaskAppArgsError = 27,           // app层请求入参出错

  kIlinkTaskMarsErr = 31,          // 客户端本地系统错误，mars的其中错误码
  kIlinkTaskSocketUserBreak = 32,  // 用户主动断开连接
  kIlinkTaskTimeout =
      33,  // 本地执行任务超时出错，如果是使用会话加密的检查登录密钥是否更新，也有可能网络不通
  kIlinkTaskNotNetErr = 34,           // 当前设备无网络
  kIlinkTaskPkgTimeout = 35,          // CGI数据包发送超时
  kIlinkTaskCreateSocketFailed = 36,  // 创建TCP连接失败
  kIlinkTaskSocketShutdown = 37,      // TCP连接被关闭
  kIlinkTaskSocketReadonce = 38,      // HTTP读数据失败
  kIlinkTaskSocketRecvErr = 39,  // 接收数据超时，主要是在心跳包等待回包的时候
  kIlinkTaskNetMsgxpHandleBufferErr = 40,  // MXPKG报头数据解析出错
  kIlinkTaskDnsMakeSocketPrepared = 41,    // DNS失败，无法通过DNS拿到IP
  kIlinkTaskHttpLongPollingTimeout = 42,   // LongPolling任务正常等待超时

  kIlinkTaskCloudLinkErr = 50,    // 云端代理链路失败，返回非0
  kIlinkTaskCloudServerErr = 51,  // 云端代理后台失败，返回非0

  kIlinkTaskWebSocketLinkErr = 60,  // WebSocket链路失败，返回非0

  kIlinkTaskH5TransferDataErr = 70,   // H5Transfer反序列化失败
  kIlinkTaskH5TransferBaseErr = 71,   // H5Transfer BaseResponse后台返回非0
  kIlinkTaskH5TransferJsApiErr = 72,  // H5Transfer JsApiResponse后台返回非0

  // ********************** WMPF 产生的错误 **********************
  kWMPFErrCodeStart = 0x40000000,
  kHostMojoBrokenErr = kWMPFErrCodeStart,  // host 到 browser 之间的 mojo 断开
  kCanNotAutoLogin,                        // 无法自动登录，需要先主动登录一次。
  kParametersError,                        // 参数错误
  kWrongThirdSdkMode,  // 没有或在错误的三方模式下运行。检查 product-id 是否正确
  kAsyncLoginInFlight,  // 异步登录过程中无法再次发起一个登录请求
  kAlreadyLoggedIn      // 已经处于登录状态
};

/***************************  Cookie begin ******************************/
typedef enum {
  COOKIE_PRIORITY_LOW = -1,
  COOKIE_PRIORITY_MEDIUM = 0,
  COOKIE_PRIORITY_HIGH = 1,
} cookie_priority_t;

typedef enum {
  COOKIE_SAME_SITE_UNSPECIFIED = 0,
  COOKIE_SAME_SITE_NO_RESTRICTION = 1,
  COOKIE_SAME_SITE_LAX_MODE = 2,
  COOKIE_SAME_SITE_STRICT_MODE = 3,
} cookie_same_site_t;

/***************************  Cookie  end *************************/

/************** ResourceManager begin *****************/
#define FLAG_MODIFY_RESPONSE 1
#define FLAG_MODIFY_REQUEST 2

struct HeaderMapItem {
  const char* name;
  const char* value;
};

typedef enum PostDataType {
  PDT_TYPE_EMPTY = 0,
  PDT_TYPE_BYTES,
  PDT_TYPE_FILE,
} PostDataType;

struct PostDataItem {
  int32_t type;
  uint8_t* data;
  int32_t data_len;
};

enum class ResourceInterceptedType { kUnknown = 0, kBinary, kString };

/************** ResourceManager end *****************/

/******** IPermissionHandler begin *****************/
enum class IPermissionHandlerResult {
  PERMISSION_RESULT_ACCEPT = 0,
  PERMISSION_RESULT_ACCEPT_ONE_TIME,
  PERMISSION_RESULT_DENY,
  PERMISSION_RESULT_DISMISS,
  PERMISSION_RESULT_IGNORE,
  PERMISSION_RESULT_DEFAULT,
};

/******** IPermissionHandler end *****************/

/******** IKeyboardHandler  begin *****************/
enum class KeyEventType {
  KEYEVENT_RAWKEYDOWN = 0,
  KEYEVENT_KEYDOWN,
  KEYEVENT_KEYUP,
  KEYEVENT_CHAR,
};

typedef enum KeyEventFlag {
  EVENTFLAG_NONE = 0,
  EVENTFLAG_CAPS_LOCK_ON = 1 << 0,
  EVENTFLAG_SHIFT_DOWN = 1 << 1,
  EVENTFLAG_CONTROL_DOWN = 1 << 2,
  EVENTFLAG_ALT_DOWN = 1 << 3,
  EVENTFLAG_LEFT_MOUSE_BUTTON = 1 << 4,
  EVENTFLAG_MIDDLE_MOUSE_BUTTON = 1 << 5,
  EVENTFLAG_RIGHT_MOUSE_BUTTON = 1 << 6,
  /// Mac OS-X command key.
  EVENTFLAG_COMMAND_DOWN = 1 << 7,
  EVENTFLAG_NUM_LOCK_ON = 1 << 8,
  EVENTFLAG_IS_KEY_PAD = 1 << 9,
  EVENTFLAG_IS_LEFT = 1 << 10,
  EVENTFLAG_IS_RIGHT = 1 << 11,
  EVENTFLAG_ALTGR_DOWN = 1 << 12,
  EVENTFLAG_IS_REPEAT = 1 << 13,
} KeyEventFlag;

typedef struct KeyEventInfo {
  uint32_t type;       // KeyEventType
  uint32_t modifiers;  // KeyEventFlag
  int32_t windows_key_code;
  int32_t native_key_code;
  int32_t is_system_key;
  char16_t character;
  char16_t unmodified_character;
  int focus_on_editable_field;
} KeyEventInfo;

/******** IKeyboardHandler  end *****************/

/******** XWebPdfPrintSettings  being **************/
typedef enum {
  PDF_PRINT_MARGIN_DEFAULT,
  PDF_PRINT_MARGIN_NONE,
  PDF_PRINT_MARGIN_CUSTOM,
} XWebPdfPrintMarginType;

typedef struct XWebPdfPrintSettings {
  int landscape;
  int print_background;
  double scale;
  double paper_width;
  double paper_height;
  int prefer_css_page_size;
  XWebPdfPrintMarginType margin_type;
  double margin_top;
  double margin_right;
  double margin_bottom;
  double margin_left;
  char* page_ranges;
  int display_header_footer;
  const char* header_template;
  const char* footer_template;
  int generate_tagged_pdf;
  int generate_document_outline;
} XWebPdfPrintSettings;

/********  XWebPdfPrintSettings  end **************/

#ifndef _WIN32
#undef interface
#endif

#endif  // WMPF_INTERFACE_COMMON_DEF_H_
