# wxwork spec sdk demo for python

## 目录结构说明
- README.md: 本说明
- wwspecapisdk.so: sdk
- demoloadsdk.py: demo
- start.sh: 启动脚本

## 依赖
- 目前只支持python3
- 使用前需要安装`pycryptodome`库
  ```
  pip3 install pycryptodome
  ```

## 使用说明
可直接打开调试模式进行使用。详见 [专区调试模式](https://developer.work.weixin.qq.com/document/54809)（注意：提交到专区审核，不能带相关调试的参数）
`./start.sh 1 {debug_token} {access_token}`

## 更新日志
### 2.1.1
> sdk版本要求: `>= 1.2.3`
> 此版本demo wwspecapisdk.so 版本为 `1.2.3`

- 将`WWToSpecHTTPReqDecoder`拿到的req_id，传入`ChatDataSDK`，方便关联请求日志
- 重构任务处理框架，提高并发处理能力。支持多进程+多线程，同时控制worker数，增加请求队列处理
- 启动命令行参数说明：
    * 保留原有的3个参数（仅本地调试需要）：
    ./demoloadsdk.py <debug_mode> <debug_token> <access_token>
    * 新增以下6个参数（可从第1个参数开始指定，不需要预留前面3个位置兼容老参数）：
    --io_workers 指定accept请求的进程数
    --thread_workers 指定每个io进程的worker数
    --queue_size 指定io worker接受请求的队列长度（`socketserver.ThreadingTCPServer`），一般不需要显式设置
    --clean_check_internal 指定异步清理过期文件线程检查间隔
    --clean_expire_seconds 指定清理N秒以前的旧文件
    --monitor_internal 指定异步监控线程检查间隔
- 增加`monitor_job`监控日志，输出信息包括 io进程、worker数、busy worker数、队列长度
- 增加请求处理耗时日志

### 2.0.5
> sdk版本要求: `>= 1.2.2`
> 此版本demo wwspecapisdk.so 版本为 `1.2.2`

- 增加分页获取会话记录接口的使用演示 `get_msg_list_by_page_id`
- `ThreadingTCPServer.request_queue_size`改为`2048`，支持高并发connect

### 2.0.4
> sdk版本要求: `>= 1.2.1`
> 此版本demo wwspecapisdk.so 版本为 `1.2.1`

- `func`为`document_list`废弃，改用`knowledge_base_list`，旧的暂时继续兼容
- 增加知识集相关接口的使用演示 `knowledge_base_*`
- 增加员工或客户名称搜索接口的使用演示 `search_contact_or_customer`
- `wework_call`逻辑调整为先本地生成notify_id，并写本地文件成功后，再调`spec_notify_app`通知应用后台来拉数据
- `start.sh`指定utf8编码方式`PYTHONIOENCODING=utf-8`

### 2.0.3
> sdk版本要求: `>= 1.1.1`
> 此版本demo wwspecapisdk.so 版本为 `1.1.1`

- 回调数据本地缓存写入子目录`/mnt/data/callback_notify/`，并支持定期清理，默认每120s清理1200s前的文件
- 使用`spec_log_info()/spec_log_error()/spec_log_debug()`打日志。详见 [专区程序开发指引](https://developer.work.weixin.qq.com/document/54006)
- start.sh支持本地调试，`./start.sh 1 {debug_token} {access_token}` 即可开启本地模式。注意：提交到专区审核的参数，不能带相关调试的参数）
- `do_async_job`读取notify_id的回调数据，改为不依赖`func_req.get("notify_id")`，而是`self.req_decode.get_notify_id()`
- demo内部错误，使用`spec_make_internal_error_rsp_data`构造返回包
