import http.server
import socketserver
import json
import ctypes
import os
import threading
import multiprocessing
import argparse
import concurrent.futures

from wwspecapisdk import *

DEMO_VERSION = "2.1.1"
PORT = 8080
CORP_MODEL_CORP_CALL = 1
CORP_MODEL_WEWORK_CALL = 2

CALLBACK_NOTIFY_CLEAN_CHECK_INTERVAL = 120  # 检查间隔
CALLBACK_NOTIFY_CLEAN_EXPIRE_SECONDS = 1200  # CALLBACK_NOTIFY_DIR文件保留时间
MONITOR_INTERVAL = 10
CALLBACK_NOTIFY_DIR = "/mnt/data/callback_notify/"

active_task_num = 0
active_task_lock = threading.Lock()

class AiRequestHandler(http.server.SimpleHTTPRequestHandler):
    def __init__(self, *args, **kwargs):
        self.req_decode = None
        self.func_mapping = {
        "echo": self.do_echo,
        "sync_msg": self.do_sync_msg,
        "get_msg_list_by_page_id": self.do_get_msg_list_by_page_id,
        "get_group_chat": self.do_get_group_chat,
        "get_agree_status_single": self.do_get_agree_status_single,
        "get_agree_status_room": self.do_get_agree_status_room,
        "set_hide_sensitiveinfo_config": self.do_set_hide_sensitiveinfo_config,
        "get_hide_sensitiveinfo_config": self.do_get_hide_sensitiveinfo_config,
        "search_chat": self.do_search_chat,
        "search_msg": self.do_search_msg,
        "create_rule": self.do_create_rule,
        "get_rule_list": self.do_get_rule_list,
        "get_rule_detail": self.do_get_rule_detail,
        "update_rule": self.do_update_rule,
        "delete_rule": self.do_delete_rule,
        "get_hit_msg_list": self.do_get_hit_msg_list,
        "create_sentiment_task": self.do_create_sentiment_task,
        "get_sentiment_result": self.do_get_sentiment_result,
        "create_summary_task": self.do_create_summary_task,
        "get_summary_result": self.do_get_summary_result,
        "create_customer_tag_task": self.do_create_customer_tag_task,
        "get_customer_tag_result": self.do_get_customer_tag_result,
        "create_recommend_dialog_task": self.do_create_recommend_dialog_task,
        "get_recommend_dialog_result": self.do_get_recommend_dialog_result,
        "create_model_task": self.do_create_model_task,
        "get_model_task_result": self.do_get_model_task_result,
        "document_list": self.do_knowledge_base_list,  # 废弃，暂时继续兼容，请使用 knowledge_base_list
        "knowledge_base_list": self.do_knowledge_base_list,
        "knowledge_base_create": self.do_knowledge_base_create,
        "knowledge_base_detail": self.do_knowledge_base_detail,
        "knowledge_base_add_doc": self.do_knowledge_base_add_doc,
        "knowledge_base_remove_doc": self.do_knowledge_base_remove_doc,
        "knowledge_base_modify_name": self.do_knowledge_base_modify_name,
        "knowledge_base_delete": self.do_knowledge_base_delete,
        "create_spam_task": self.do_create_spam_task,
        "get_spam_result": self.do_get_spam_result,
        "create_chatdata_export_job": self.do_create_chatdata_export_job,
        "get_chatdata_export_job_status": self.do_get_chatdata_export_job_status,
        "program_async_job_call_back": self.do_program_async_job_call_back,
        "spec_notify_app": self.do_spec_notify_app,
        "do_async_job": self.do_async_job,
        "create_program_task": self.do_create_program_task,
        "get_program_task_result": self.do_get_program_task_result,
        "create_ww_model_task": self.do_create_ww_model_task,
        "get_ww_model_result": self.do_get_ww_model_result,
        "search_contact_or_customer": self.do_search_contact_or_customer,
        }
        super().__init__(*args, **kwargs)

    def do_GET(self):
        response = f"Echo: {self.path}".encode("utf-8")
        # 发送响应头
        self.send_response(200)
        self.send_header("Content-Type", "application/json")
        self.send_header("Content-Length", str(len(response)))
        self.end_headers()
        # 发送响应内容
        self.wfile.write(response)

    def safe_int(self, s):
        try:
            return int(s)
        except ValueError:
            return 0

    def safe_json_loads(self, json_string):
        try:
            return json.loads(json_string)
        except json.JSONDecodeError:
            return None

    def send_err(self, code, message=None, explain=None):
        response = f"{message}".encode("utf-8")
        self.send_response(code)
        self.send_header("Content-type", "application/json")
        self.end_headers()
        if response is not None:
            self.wfile.write(response)

    def send_rsp(self, rsp_data):
        rsp = WWToSpecHTTPRspConstructor(rsp_data)
        rsp_header = rsp.get_normal_header()
        rsp_body = rsp.get_encoded_body()
        # 发送响应内容
        self.send_response(200)
        # spec_log_debug(f"rsp_data: %s %s" % (len(rsp_data), rsp_data[:256]))
        spec_log_debug(f"rsp_body: %s %s" % (len(rsp_body), rsp_body[:256]))
        for k, v in rsp_header.items():
            self.send_header(k, v)
        self.end_headers()
        if rsp_body is not None:
            self.wfile.write(rsp_body.encode("utf-8"))

    def send_retry_notify_rsp(self, rsp_data, status: str = "1"):
        spec_log_info(f"retry_notify_rsp {status}")
        rsp = WWToSpecHTTPRspConstructor(rsp_data)
        rsp_header = rsp.get_retry_notify_header(status)
        rsp_body = rsp.get_encoded_body()
        spec_log_debug(f"rsp_header: {rsp_header}")
        # 发送响应内容
        self.send_response(200)
        spec_log_debug(f"rsp_body: {rsp_body}")
        for k, v in rsp_header.items():
            self.send_header(k, v)
        self.end_headers()
        if rsp_body is not None:
            self.wfile.write(rsp_body.encode("utf-8"))

    def process_func(self, sdk, corp_call_data, sdk_func, msg):
        is_async = self.req_decode.get_is_async()
        job_info = self.req_decode.get_job_info()
        corpid = self.req_decode.get_corpid()
        agentid = self.req_decode.get_agentid()
        ability_id = self.req_decode.get_ability_id()
        spec_log_info(f"is_async: {is_async}")
        if is_async:
            #异步请求，先回响应包
            self.send_rsp("")

        spec_log_info(msg)
        func_req = json.dumps(corp_call_data.get("func_req", ""))
        spec_log_info(f"func_req: {func_req}")
        rsp = sdk_func(func_req)
        # spec_log_debug(f"rsp: {rsp}")
        spec_log_debug(f"rsp: %s %s..." % (len(rsp), rsp[:256]))

        if is_async:
            #上报异步异步任务结果
            report_sdk = ChatDataSDK(corpid, agentid, ability_id, job_info)
            report_sdk.set_req_id(self.req_decode.get_req_id())
            json_result = {"errcode":0, "result":rsp}
            report_sdk.program_async_job_call_back(json.dumps(json_result))
        else:
            self.send_rsp(rsp)

    def do_echo(self, sdk, corp_call_data):
        # 自定义的请求{"func":"echo","func_req":"echo func test"}
        self.process_func(sdk, corp_call_data, sdk.echo, "do_echo")

    def do_sync_msg(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.sync_msg, "do_sync_msg")

    def do_get_msg_list_by_page_id(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_msg_list_by_page_id, "do_get_msg_list_by_page_id")

    def do_get_group_chat(self, sdk, corp_call_data):
        #{"func":"get_group_chat","func_req":{"chatid":"wrNplhCgAAIVZohLe57zKnvIV7xBKrig"}}
        self.process_func(sdk, corp_call_data, sdk.get_group_chat, "do_get_group_chat")

    def do_get_agree_status_single(self, sdk, corp_call_data):
        #{"func":"get_agree_status_single", "func_req":{"item":[{"open_userid":"XuJinSheng","external_userid":"wmeDKaCQAAGd9oGiQWxVsAKwV2HxNAAA"}]}}
        self.process_func(sdk, corp_call_data, sdk.get_agree_status_single, "do_get_agree_status_single")

    def do_get_agree_status_room(self, sdk, corp_call_data):
        #{"func":"get_agree_status_single", "func_req":{"item":[{"open_userid":"XuJinSheng","external_userid":"wmeDKaCQAAGd9oGiQWxVsAKwV2HxNAAA"}]}}
        self.process_func(sdk, corp_call_data, sdk.get_agree_status_room, "do_get_agree_status_single")

    def do_set_hide_sensitiveinfo_config(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.set_hide_sensitiveinfo_config, "do_set_hide_sensitiveinfo_config")

    def do_get_hide_sensitiveinfo_config(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_hide_sensitiveinfo_config, "do_get_hide_sensitiveinfo_config")

    def do_search_chat(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.search_chat, "do_search_chat")

    def do_search_msg(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.search_msg, "do_search_msg")

    def do_create_rule(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_rule, "do_create_rule")

    def do_get_rule_list(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_rule_list, "do_get_rule_list")

    def do_get_rule_detail(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_rule_detail, "do_get_rule_detail")

    def do_update_rule(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.update_rule, "do_update_rule")

    def do_delete_rule(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.delete_rule, "do_delete_rule")

    def do_get_hit_msg_list(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_hit_msg_list, "do_get_hit_msg_list")

    def do_create_sentiment_task(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_sentiment_task, "do_create_sentiment_task")

    def do_get_sentiment_result(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_sentiment_result, "do_get_sentiment_result")

    def do_create_summary_task(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_summary_task, "do_create_summary_task")

    def do_get_summary_result(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_summary_result, "do_get_summary_result")

    def do_create_customer_tag_task(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_customer_tag_task, "do_create_customer_tag_task")

    def do_get_customer_tag_result(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_customer_tag_result, "do_get_customer_tag_result")

    def do_create_recommend_dialog_task(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_recommend_dialog_task, "do_create_recommend_dialog_task")

    def do_get_recommend_dialog_result(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_recommend_dialog_result, "do_get_recommend_dialog_result")

    def do_create_model_task(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_model_task, "do_create_model_task")

    def do_get_model_task_result(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_model_task_result, "do_get_model_task_result")

    def do_knowledge_base_list(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.knowledge_base_list, "do_knowledge_base_list")

    def do_knowledge_base_create(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.knowledge_base_create, "do_knowledge_base_create")

    def do_knowledge_base_detail(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.knowledge_base_detail, "do_knowledge_base_detail")

    def do_knowledge_base_add_doc(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.knowledge_base_add_doc, "do_knowledge_base_add_doc")

    def do_knowledge_base_remove_doc(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.knowledge_base_remove_doc, "do_knowledge_base_remove_doc")

    def do_knowledge_base_modify_name(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.knowledge_base_modify_name, "do_knowledge_base_modify_name")

    def do_knowledge_base_delete(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.knowledge_base_delete, "do_knowledge_base_delete")

    def do_create_spam_task(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_spam_task, "do_create_spam_task")

    def do_get_spam_result(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_spam_result, "do_get_spam_result")

    def do_create_chatdata_export_job(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_chatdata_export_job, "do_create_chatdata_export_job")

    def do_get_chatdata_export_job_status(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_chatdata_export_job_status, "do_get_chatdata_export_job_status")

    def do_program_async_job_call_back(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.program_async_job_call_back, "do_program_async_job_call_back")

    def do_spec_notify_app(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.spec_notify_app, "do_spec_notify_app")

    def do_create_program_task(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_program_task, "do_create_program_task")

    def do_get_program_task_result(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_program_task_result, "do_get_program_task_result")

    def do_create_ww_model_task(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.create_ww_model_task, "do_create_ww_model_task")

    def do_get_ww_model_result(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.get_ww_model_result, "do_get_ww_model_result")

    def do_search_contact_or_customer(self, sdk, corp_call_data):
        self.process_func(sdk, corp_call_data, sdk.search_contact_or_customer, "do_search_contact_or_customer")

    def do_async_job(self, sdk, corp_call_data):
        # func_req = json.dumps(corp_call_data.get("func_req", ""))
        # notify_id = corp_call_data.get("func_req", "").get("notify_id", "")
        notify_id = self.req_decode.get_notify_id()  # 修正为从self.req_decode取
        # cbname = "/mnt/data/" + notify_id
        cbname = CALLBACK_NOTIFY_DIR + notify_id
        rsp = None
        with open(cbname, "r") as file:
            rsp = file.read()
            # os.remove(cbname)  # 统一定时删除
        spec_log_info(f"do_async_job rsp: {rsp}");
        self.send_rsp(rsp)

    def corp_call(self):
        data = self.req_decode.get_data()
        #print("corp_call", data)
        # 企业自定义的数据
        input_data_json = json.loads(data)
        #print(type(input_data_json), input_data_json)
        corp_call_data = input_data_json.get("input", "")
        spec_log_info(f"corp_call_data: {corp_call_data}")

        func = corp_call_data.get("func", "")
        job_info = self.req_decode.get_job_info()
        corpid = self.req_decode.get_corpid()
        agentid = self.req_decode.get_agentid()
        ability_id = self.req_decode.get_ability_id()
        #初始化sdk
        sdk = ChatDataSDK(corpid, agentid, ability_id, job_info)
        sdk.set_req_id(self.req_decode.get_req_id())

        # 示例代码,业务根据自己需求实现自己的数据和操作
        if func in self.func_mapping:
            self.func_mapping[func](sdk, corp_call_data)
        else:
            rsp = spec_make_internal_error_rsp_data("unknown func")
            self.send_rsp(rsp)

    def wework_call(self):
        spec_log_info("wework_call")
        job_info = self.req_decode.get_job_info()
        corpid = self.req_decode.get_corpid()
        agentid = self.req_decode.get_agentid()
        data = self.req_decode.get_data()
        ability_id = self.req_decode.get_ability_id()

        # 生成本地notify_id，写本地文件，最后再notify_app
        notify_id = spec_gen_notify_id()  # 确保非空且唯一
        if notify_id != "": 
            # 写本地文件
            cbname = CALLBACK_NOTIFY_DIR + notify_id
            spec_log_info(f"write file {cbname}")
            with open(cbname, "w") as file:
                file.write(data)
            spec_log_info(f"write file end {cbname}")
        else:
            spec_log_error("write file fail, notify_id empty")
            pass

        #初始化sdk
        sdk = ChatDataSDK(corpid, agentid, ability_id, job_info)
        sdk.set_req_id(self.req_decode.get_req_id())  # 透传req-id，方便关联请求
        notify_req = {"notify_id": notify_id}
        rsp = sdk.spec_notify_app(json.dumps(notify_req))
        spec_log_info(f"rsp: {rsp}")  # 预期返回的notify_id跟请求带过去的一致
        self.send_rsp("")

    def do_POST(self):
        content_length = self.safe_int(self.headers.get("Content-Length", 0))
        post_data = self.rfile.read(content_length).decode("utf-8")
        spec_log_info(f"read data {content_length} {post_data[:256]}")

        req_id = ""
        try:
            self.req_decode = WWToSpecHTTPReqDecoder(list(self.headers.items()), post_data)
            call_type = self.req_decode.get_call_type()
            is_async = self.req_decode.get_is_async()
            job_info = self.req_decode.get_job_info()
            corpid = self.req_decode.get_corpid()
            agentid = self.req_decode.get_agentid()
            ability_id = self.req_decode.get_ability_id()
            notify_id = self.req_decode.get_notify_id()
            req_id = self.req_decode.get_req_id();
            spec_log_info(f"req param {req_id} {corpid} {agentid} {ability_id} {notify_id}")

            if call_type == CORP_MODEL_CORP_CALL:
                self.corp_call()
            elif call_type == CORP_MODEL_WEWORK_CALL:
                self.wework_call()
            else:
                rsp = spec_make_internal_error_rsp_data("unknown call_type")
                self.send_rsp(rsp)
        except WWToSpecRetryNotifyException as e:
            # 构造特殊回包通知企微后台重试
            spec_log_error(f"WWToSpecRetryNotifyException {e}")
            self.send_retry_notify_rsp("", e.GetStatus())
        except Exception as e:
            spec_log_error(f"error {e}")
            rsp = spec_make_internal_error_rsp_data(str(e))
            self.send_rsp(rsp)
            # return

        pass
   
# 定期删除过期文件
def clean_job():
    spec_log_info("[clean_job]", CALLBACK_NOTIFY_DIR, CALLBACK_NOTIFY_CLEAN_CHECK_INTERVAL, CALLBACK_NOTIFY_CLEAN_EXPIRE_SECONDS)
    while True:
        # 获取当前时间
        current_time = datetime.datetime.now()
        
        # 遍历文件夹中的文件
        delete_cnt = 0
        total_cnt = 0
        for filename in os.listdir(CALLBACK_NOTIFY_DIR):
            total_cnt += 1
            # file_path = os.path.join(CALLBACK_NOTIFY_DIR, filename)
            file_path = CALLBACK_NOTIFY_DIR + filename
            
            # 检查文件的修改时间
            modified_time = datetime.datetime.fromtimestamp(os.path.getmtime(file_path))
            # 计算文件的存在时间差
            time_diff = current_time - modified_time
            
            # 如果文件存在时间超过指定分钟数，则删除文件
            if time_diff.total_seconds() > CALLBACK_NOTIFY_CLEAN_EXPIRE_SECONDS:
                delete_cnt += 1
                try:
                    os.remove(file_path)
                    spec_log_info(f"[clean_job] expired file deleted", file_path, modified_time.strftime("%c"))
                except Exception as e:
                    spec_log_error(f"[clean_job] delete expired file fail: {e}", file_path, modified_time.strftime("%c"))
            pass

        spec_log_info(f"[clean_job] delete {delete_cnt}/{total_cnt} files")
        time.sleep(CALLBACK_NOTIFY_CLEAN_CHECK_INTERVAL)
        pass
    pass

def monitor_job(executor: concurrent.futures.ThreadPoolExecutor, idx: int = 0):
    log_tag = "[monitor_job]"
    while True:
        try:
            total = executor._max_workers;
            queue_size = executor._work_queue.qsize()
            spec_log_info(f"{log_tag} io {idx} total {total} busy {active_task_num} qsize {queue_size}")
        except Exception as e:
            spec_log_info(f"{log_tag} io {idx} except {e}")

        time.sleep(MONITOR_INTERVAL)
        pass
    pass

# 自定义 ThreadingTCPServer，使用线程池，控制worker数
class ThreadPoolTCPServer(socketserver.ThreadingTCPServer):
    def __init__(self, server_address, handler_class, max_workers=10, queue_size=1024):
        # super.init 前设置
        socketserver.ThreadingTCPServer.allow_reuse_address = True
        socketserver.ThreadingTCPServer.request_queue_size = queue_size  # set socketserver.ThreadingTCPServer.request_queue_size
        super().__init__(server_address, handler_class)

        # 
        self.daemon_threads = True
        self.executor = concurrent.futures.ThreadPoolExecutor(max_workers=max_workers)

        spec_log_info(f"queue_size: {socketserver.ThreadingTCPServer.request_queue_size} max_workers: {self.executor._max_workers}")

    def GetExecutor(self):
        return self.executor

    def process_request(self, request, client_address):
        # 将请求提交到线程池处理
        # self.executor.submit(self.finish_request, request, client_address)
        self.executor.submit(self.process_request_thread, request, client_address)

    def process_request_thread(self, request, client_address):
        # 重写，加统计
        global active_task_lock, active_task_num
        with active_task_lock:
            active_task_num += 1

        start_time = time.perf_counter()

        super().process_request_thread(request, client_address)

        with active_task_lock:
            active_task_num -= 1

        end_time = time.perf_counter()
        elapsed_time_ms = int((end_time - start_time) * 1000)
        spec_log_info(f"END process_request cost {elapsed_time_ms}")

# 进程
def process_io_worker(httpd, idx):
    spec_log_info(f"start io worker {idx}...")

    monitor_thread = threading.Thread(target = monitor_job, args=(httpd.GetExecutor(), idx))
    monitor_thread.start()

    httpd.serve_forever()
    pass

def main():
    parser = argparse.ArgumentParser(description="")
    # 这三个参数兼容老版本
    parser.add_argument("debug_mode", type=int, nargs="?", default=0, help="是否开启本地调试模式")
    parser.add_argument("debug_token", type=str, nargs="?", default="", help="debug_token")
    parser.add_argument("access_token", type=str, nargs="?", default="", help="应用access_token")

    parser.add_argument("--thread_workers", type=int, default=128, help="worker线程数（每io进程），建议不超过256")
    parser.add_argument("--io_workers", type=int, default=4, help="io进程数，建议不超过4")
    parser.add_argument("--queue_size", type=int, default=2048, help="请求队列长度，一般不需要调整")

    parser.add_argument("--clean_check_internal", type=int, default=120, help="异步清理过期文件线程检查间隔")
    parser.add_argument("--clean_expire_seconds", type=int, default=1200, help="清理N秒以前的旧文件")
    parser.add_argument("--monitor_internal", type=int, default=10, help="异步监控线程检查间隔")

    args = parser.parse_args()
    spec_log_info(f"read args {args}")

    # 开启调试模式，debug_mode/debug_token/access_token 都需要
    if args.debug_mode == 1 and args.debug_token != "" and args.access_token != "":
        spec_open_debug_mode(args.debug_token, args.access_token)
        # spec_debug_use_test_domain(True)

    # 更新全局变量
    global CALLBACK_NOTIFY_CLEAN_CHECK_INTERVAL
    global CALLBACK_NOTIFY_CLEAN_EXPIRE_SECONDS
    global MONITOR_INTERVAL
    CALLBACK_NOTIFY_CLEAN_CHECK_INTERVAL = args.clean_check_internal
    CALLBACK_NOTIFY_CLEAN_EXPIRE_SECONDS = args.clean_expire_seconds
    MONITOR_INTERVAL = args.monitor_internal
    
    if not os.path.exists(CALLBACK_NOTIFY_DIR):
        try:
            os.makedirs(CALLBACK_NOTIFY_DIR, mode=0o777)
            spec_log_info("create dir", CALLBACK_NOTIFY_DIR);
        except Exception as e:
            spec_log_error(f"FATAL! create dir fail: {CALLBACK_NOTIFY_DIR}, exception: {e}")
            sys.exit(1)

    # 清理本地临时文件
    clean_thread = threading.Thread(target = clean_job)
    clean_thread.start()

    # socketserver.ThreadingTCPServer.allow_reuse_address = True
    # socketserver.ThreadingTCPServer.request_queue_size = 2048
    # with socketserver.ThreadingTCPServer(("", PORT), AiRequestHandler) as httpd:
    with ThreadPoolTCPServer(("0.0.0.0", PORT), AiRequestHandler, max_workers=args.thread_workers, queue_size=args.queue_size) as httpd:
        spec_log_info(f"Serving on port {PORT}, io {args.io_workers} worker {args.thread_workers}, demo version {DEMO_VERSION}, sdk version %s" % (spec_get_sdk_version()))
        # httpd.serve_forever()

        # 否则后面创建进程可能会被卡住不能执行
        time.sleep(0.5)

        # 创建多进程worker，抢占accept处理任务
        io_process_list = []
        for i in range(args.io_workers > 0 and args.io_workers or 1):
            p = multiprocessing.Process(target=process_io_worker, args=(httpd, i))
            io_process_list.append(p)
            p.start()

if __name__ == "__main__":
    main()
