# wxwork spec sdk for python

## 目录结构说明
- README.md: 本说明
- wwspecapisdk.so: sdk

## 依赖
- 目前只支持python3.6
- 使用前需要安装`pycryptodome`库
  ```
  pip3 install pycryptodome
  ```

## 使用说明
将`wwspecapisdk.so`放置于工程目录，即可使用
```
from wwspecapisdk import WWToSpecHTTPReqDecoder, WWToSpecHTTPRspConstructor, ChatDataSDK, spec_log_info, spec_log_error, spec_log_debug, spec_open_debug_mode

``` 


## 更新日志
### 1.2.3
> MD5: 0b97d823ec27b54a4e9ab3a01ce7ecde
- ChatDataSDK增加`set_req_id`，方便关联请求日志
- 支持丢弃在队列里等待过久的请求，返回错误（构造特殊回包）

### 1.2.2
> MD5: e13e15a140f6b80735029e1645a6c84b
- 新增分页获取会话记录sdk接口：`get_msg_list_by_page_id()`

### 1.2.1
> MD5: c47f0c7423983667a3d386d87c99800e 
- `document_list()` 改名为 `knowledge_base_list()`，旧接口暂时继续兼容
- 新增6个知识集管理sdk接口：`knowledge_base_create()/knowledge_base_detail()/knowledge_base_add_doc()/knowledge_base_remove_doc()/knowledge_base_modify_name()/knowledge_base_delete()`。详见 [知识集管理](https://developer.work.weixin.qq.com/document/53353)
- 新增`spec_gen_notify_id()`由本地生成notify_id，方便本地先关联notify_id和回调数据，然后再通过`spec_notify_app`通知应用
- 新增员工或客户名称搜索sdk接口：`search_contact_or_customer()`

### 1.1.1
> MD5: 9baab0b65c3fdf09a3e73fe114cf371c

- 新增日志接口`spec_log_info()/spec_log_error()/spec_log_debug()`，所打的日志将会被收集，可在web管理后台查询。详见 [专区程序开发指引](https://developer.work.weixin.qq.com/document/54006)
- 新增开启调试模式接口`spec_open_debug_mode(debug_token, access_token)`，方便本地调试。详见[专区调试模式](https://developer.work.weixin.qq.com/document/54809)
- 新增获取当前sdk版本接口`spec_get_sdk_version()`
